<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
    <title>Geecom Admin - area amministrativa</title>

	  
  </head>
  <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
	  
    <main role="main" class="bg-light" id="main">
		<div id="dashboard" class="container-fluid">
			<div class="row">
				<!-- Colonna principale -->
				<div class="col-12 py-4">
			
                                    <?php 
                                        include "include/cruscotto.php";
                                        $parametri = array("tabella"=>"geecAd_comunicazioni", "elementiPerPagina"=>10,"parametriRicerca"=>array(),"ajax"=>false);
                                        $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca, "");
                                        $ricerca->setOrdinamento("ORDER BY id DESC");
                                    ?>
					
					<div class="row my-4">
                                            <div class="col-lg-6">
                                                <div class="card mb-4 accordion box-shadow-lite">
                                                    <div class="card-header collapsed" data-toggle="collapse" href="#articoliPiuLetti">
                                                        <a class="card-title">
                                                            Ultime comunicazioni
                                                        </a>
                                                    </div>
                                                    <div id="articoliPiuLetti" class="collapse show">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table">
                                                                    <thead>
                                                                        <tr class="d-flex">
                                                                            <th scope="col" class="col-1">#</th>
                                                                            <th scope="col" class="col-7 col-lg-8 col-xl-9">Oggetto</th>
                                                                            <th scope="col" class="col-4 col-lg-3 col-xl-2">Tipo</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php 
                                                                            $risComunicazioni = $ricerca->eseguiRicerca(1);
                                                                            while($comunicazione = $risComunicazioni->fetch_assoc()) {
                                                                                echo"<tr class=\"d-flex\">
                                                                                    <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$comunicazione["id"]}</th>
                                                                                    <td class=\"col-7 col-lg-8 col-xl-9\"><a href=\"creaComunicazione.php?id={$comunicazione["id"]}\">{$comunicazione["oggetto"]} </a></td>
                                                                                    <td class=\"col-4 col-lg-3 col-xl-2\"><span class=\"badge badge-light\">{$comunicazione["tipo"]}</span></td>
                                                                                </tr>";
                                                                            }
                                                                        ?>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            <div class="col-6 col-xl-4 mx-auto">
                                                                <a class="btn btn-primary btn-block text-white leggi-tutto" href="gestioneComunicazioni.php">Vai alle comunicazioni</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
						
                                                <div class="card mb-4 accordion box-shadow-lite">
                                                    <div class="card-header collapsed" data-toggle="collapse" href="#piuCommentati">
                                                        <a class="card-title">
                                                            Risorse più scaricate
                                                        </a>
                                                    </div>
                                                    <div id="piuCommentati" class="collapse show">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table">
                                                                    <thead>
                                                                          <tr class="d-flex">
                                                                            <th scope="col" class="col-1">#</th>
                                                                            <th scope="col" class="col-7 col-lg-8 col-xl-9">Nome</th>
                                                                            <th scope="col" class="col-4 col-lg-3 col-xl-2">Download</th>
                                                                          </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php
                                                                            $ricerca->setTabella("geecAd_risorse");
                                                                            $ricerca->setOrdinamento("ORDER BY id DESC");
                                                                            $risDomandePiuLette = $ricerca->eseguiRicerca(1);
                                                                            while($risorsa = $risDomandePiuLette->fetch_assoc()) {
                                                                                echo"<tr class=\"d-flex\">
                                                                                    <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$risorsa["id"]}</th>
                                                                                    <td class=\"col-7 col-lg-8 col-xl-9\"><a href=\"creaFileScaricabile.php?id={$risorsa["id"]}\">{$risorsa["nome"]} </a></td>
                                                                                    <td class=\"col-4 col-lg-3 col-xl-2\"><span class=\"badge badge-light\">{$risorsa["numeroDownload"]}</span></td>
                                                                                </tr>";
                                                                            }
                                                                        ?>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            <div class="col-6 col-xl-4 mx-auto">
                                                                    <a class="btn btn-primary btn-block text-white leggi-tutto" href="gestioneRisorse.php">Vai alle risorse</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
						<div class="col-lg-6">
                                                    <div class="card mb-4 accordion box-shadow-lite">
                                                        <div class="card-header collapsed" data-toggle="collapse" href="#ultimiCommenti">
                                                            <a class="card-title">
                                                                Ultimi utenti collegati
                                                            </a>
                                                        </div>
                                                        <div id="ultimiCommenti" class="collapse show">
                                                            <div class="card-body">
                                                                <div class="table-responsive">
                                                                    <table class="table">
                                                                        <thead>
                                                                            <tr class="d-flex">
                                                                                <th scope="col" class="col-1">#</th>
                                                                                <th scope="col" class="col-6">Nome</th>
                                                                                <th scope="col" class="col-5">Ultimo login</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php
                                                                                $ricerca->setTabella("geec_utenti");
                                                                                $ricerca->setOrdinamento("ORDER BY ultimoLogin DESC");
                                                                                $risUtentiPiuAttivi = $ricerca->eseguiRicerca(1);
                                                                                while($utente = $risUtentiPiuAttivi->fetch_assoc()) {
                                                                                    $dataUltimoLogin = date("d/m/Y",strtotime($utente["ultimoLogin"]));
                                                                                    echo"<tr class=\"d-flex\">
                                                                                        <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$utente["id"]}</th>
                                                                                        <td class=\"col-6\"><a href=\"creaUtente.php?id={$utente["id"]}\">{$utente["nome"]} {$utente["cognome"]}</a></td>
                                                                                        <td class=\"col-5\">$dataUltimoLogin</td>
                                                                                    </tr>";
                                                                                }
                                                                            ?>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <div class="col-6 col-xl-4 mx-auto">
                                                                    <a class="btn btn-primary btn-block text-white leggi-tutto" href="gestioneUtenti.php">Tutti gi utenti</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
						
                                                    <div class="card mb-4 accordion box-shadow-lite">
                                                        <div class="card-header collapsed" data-toggle="collapse" href="#utentiInattivi">
                                                            <a class="card-title">
                                                                Utenti inattivi
                                                            </a>
                                                        </div>
                                                        <div id="utentiInattivi" class="collapse show">
                                                            <div class="card-body">
                                                                <div class="table-responsive">
                                                                    <table class="table">
                                                                        <thead>
                                                                            <tr class="d-flex">
                                                                                <th scope="col" class="col-1">#</th>
                                                                                <th scope="col" class="col-6">Nome</th>
                                                                                <th scope="col" class="col-5">Ultimo login</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php
                                                                                $ricerca->setTabella("geec_utenti");
                                                                                $ricerca->setOrdinamento("ORDER BY ultimoLogin ASC");
                                                                                $risUtentiPiuAttivi = $ricerca->eseguiRicerca(1);
                                                                                while($utente = $risUtentiPiuAttivi->fetch_assoc()) {
                                                                                    $dataUltimoLogin = date("d/m/Y",strtotime($utente["ultimoLogin"]));
                                                                                    echo"<tr class=\"d-flex\">
                                                                                        <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$utente["id"]}</th>
                                                                                        <td class=\"col-6\"><a href=\"creaUtente.php?id={$utente["id"]}\">{$utente["nome"]} {$utente["cognome"]}</a></td>
                                                                                        <td class=\"col-5\">$dataUltimoLogin</td>
                                                                                    </tr>";
                                                                                }
                                                                            ?>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <div class="col-6 col-xl-4 mx-auto">
                                                                    <a class="btn btn-primary btn-block text-white leggi-tutto" href="gestioneUtenti.php">Tutti gli utenti</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>	
					</div>
				</div><!-- /Colonna principale -->
			</div>
		</div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";

        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
	  
  </body>
</html>
